import socket

separator = '^^^^^'.encode('cp1251', errors='ignore')

def singleton(cls, *args, **kw):
    instances = {}
    def _singleton(p):
        if cls not in instances:
            instances[cls] = cls(p, *args, **kw)
        return instances[cls]
    return _singleton

@singleton
class SocketSingleton(object):
    def __init__(self, p):
        for i in range(3):
            try:
                self.sock_send = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                self.sock_send.connect(('127.0.0.1', p))
                break
            except:
                print('exception SocketSingleton')
                from time import sleep
                sleep(1)

    def send_str(self, send_str1):
        self.sock_send.sendall(send_str1.encode('cp1251', errors='ignore'))
        self.sock_send.sendall(separator)

    def end_validation(self):
        self.sock_send.sendall('###end validation###'.encode('cp1251', errors='ignore'))
        self.sock_send.sendall(separator)
        while True:
            data = self.sock_send.recv(1024)
            if data:
                self.sock_send.close()
                break

    def end_send(self):
        self.sock_send.sendall('###end send###'.encode('cp1251', errors='ignore'))
        self.sock_send.sendall(separator)


